/*
    This file is part of the LCDGraphics library for the Weebox.

    LCDGraphics is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Foobar is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with LCDGraphics.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "Colour.h"
#include <cassert>

using namespace LCDGraphics;

Colour::Colour()
{

}

Colour::Colour(int iValue)
{
	assert(iValue >= 0 && iValue <= 255);	
	if (iValue < 0) iValue = 0;
	if (iValue > 255) iValue = 255;

	mRed = mGreen = mBlue = iValue;
}

Colour::Colour(int iRed, int iGreen, int iBlue)
{
	assert(iRed >= 0 && iRed <= 255);	
	assert(iGreen >= 0 && iGreen <= 255);	
	assert(iBlue >= 0 && iBlue <= 255);	
	if (iRed < 0) iRed = 0;
	if (iRed > 255) iRed = 255;
	if (iGreen < 0) iGreen = 0;
	if (iGreen > 255) iGreen = 255;
	if (iBlue < 0) iBlue = 0;
	if (iBlue > 255) iBlue = 255;

	mRed = iRed;
	mGreen = iGreen;
	mBlue = iBlue;
}
