/*
    This file is part of the LCDGraphics library for the Weebox.

    LCDGraphics is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Foobar is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with LCDGraphics.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef INCLUDED_LCDGRAPHICS_COLOURMATHS_H
#define INCLUDED_LCDGRAPHICS_COLOURMATHS_H

#include "Colour.h"

namespace LCDGraphics
{
#define LCDGRAPHICS_IMPLEMENT_OPERATOR(OPERATOR, SHIFT) \
	Colour operator OPERATOR (const Colour& iLhs, const Colour& iRhs) \
	{ \
		return Colour((iLhs.GetRed() OPERATOR iRhs.GetRed()) >> SHIFT, \
		              (iLhs.GetBlue() OPERATOR iRhs.GetBlue()) >> SHIFT, \
					  (iLhs.GetGreen() OPERATOR iRhs.GetGreen()) >> SHIFT); \
	}
	LCDGRAPHICS_IMPLEMENT_OPERATOR(+, 0)
	LCDGRAPHICS_IMPLEMENT_OPERATOR(-, 0)
	LCDGRAPHICS_IMPLEMENT_OPERATOR(*, 8) // TODO: (255 * 255) >> 8 == 254!
#undef LCDGRAPHICS_IMPLEMENT_OPERATOR
}

#endif
