/*
    This file is part of the LCDGraphics library for the Weebox.

    LCDGraphics is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Foobar is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with LCDGraphics.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef INCLUDED_LCDGRAPHICS_IDISPLAY_H
#define INCLUDED_LCDGRAPHICS_IDISPLAY_H

namespace LCDGraphics
{
	class Colour;
	class Point;
	class Rectangle;

	enum DrawMode
	{
		DM_SOLID,
		DM_XOR,
	};

	class IDisplay
	{
	public:
		virtual ~IDisplay() {}

		virtual int GetHeight() const = 0;
		virtual int GetWidth() const = 0;
		virtual int GetNumColourChannels() const = 0;
		virtual int GetColourDepth() const = 0;

		virtual void Clear(const Colour& iColour) = 0;

		virtual void SetColour(const Colour& iColour) = 0;
		virtual Colour GetColour() const = 0;

		virtual void SetDrawMode(DrawMode iDrawMode) = 0;
		virtual DrawMode GetDrawMode() const = 0;

		virtual void DrawPixel(const Point& iPosition) = 0;
		virtual void DrawLine(const Point& iFrom, const Point& iTo) = 0;
		virtual void DrawRegion(const Rectangle& iRectangle) = 0;
		virtual void DrawRegionOutline(const Rectangle& iRectangle) = 0;

		virtual void DrawRaster1(const Point& iPosition, const unsigned char* iData, int iWidth, int iHeight, int iStride) = 0;
		virtual void DrawRaster8(const Point& iPosition, const unsigned char* iData, int iWidth) = 0;

		virtual void ClearClipRegion() = 0;
		virtual void SetClipRegion(const Rectangle& iRectangle) = 0;
		virtual void GetClipRegion(Rectangle& oRectangle) const = 0;

		virtual void BeginUpdate() = 0;
		virtual void EndUpdate() = 0;
	};

	extern IDisplay* CreateDisplay();
}

#endif
