/*
    This file is part of the LCDGraphics library for the Weebox.

    LCDGraphics is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Foobar is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with LCDGraphics.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef INCLUDED_LCDGRAPHICS_IFONTMANAGER_H
#define INCLUDED_LCDGRAPHICS_IFONTMANAGER_H

namespace LCDGraphics
{
	class IDisplay;
	class Point;
	class Rectangle;

	class IFont
	{
	public:
		virtual ~IFont() {}

		virtual void Render(IDisplay* iDisplay, const char* iText, const Point& iStartPos) = 0;

		virtual void GetBoundingBox(const char* iText, const Point& iStartPos, Rectangle& oBounds) const = 0;

		virtual int GetLineGapInPixels() const = 0;
	};

	class IFontManager
	{
	public:
		virtual ~IFontManager() {}

		virtual IFont* CreateFont(const char* iFilename, int iFontSize) = 0;
	};

	extern IFontManager* CreateFontManager();
}

#endif
