/*
    This file is part of the LCDGraphics library for the Weebox.

    LCDGraphics is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Foobar is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with LCDGraphics.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef INCLUDED_LCDGRAPHICS_POINTMATHS_H
#define INCLUDED_LCDGRAPHICS_POINTMATHS_H

#include "Point.h"

namespace LCDGraphics
{
#define LCDGRAPHICS_IMPLEMENT_OPERATOR(OPERATOR) \
	Point operator OPERATOR (const Point& iLhs, const Point& iRhs) \
	{ \
		return Point(iLhs.GetX() OPERATOR iRhs.GetX(), iLhs.GetY() OPERATOR iRhs.GetY()); \
	}
	LCDGRAPHICS_IMPLEMENT_OPERATOR(+)
	LCDGRAPHICS_IMPLEMENT_OPERATOR(-)
#undef LCDGRAPHICS_IMPLEMENT_OPERATOR
}

#endif
