/*
    This file is part of the LCDGraphics library for the Weebox.

    LCDGraphics is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Foobar is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with LCDGraphics.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef INCLUDED_LCDGRAPHICS_RECTANGLE_H
#define INCLUDED_LCDGRAPHICS_RECTANGLE_H

#include "Point.h"

namespace LCDGraphics
{
	class Rectangle
	{
	public:
		Rectangle();
		Rectangle(const Point& iPoint1, const Point& iPoint2);
		Rectangle(const Point& iTopLeft, int iWidth, int iHeight);

		int GetMinX() const;
		int GetMinY() const;
		int GetMaxX() const;
		int GetMaxY() const;
		int GetWidth() const;
		int GetHeight() const;

		void SetEmpty();
		bool IsEmpty() const;

		Point GetPoint(int iXpos, int iYpos) const;

		void ClipTo(const Rectangle& iOther);
		void ExtendToInclude(const Rectangle& iOther);

		void Grow(int iPixels);
		void Shrink(int iPixels);

		bool Contains(const Point& iPoint) const;
		bool Contains(const Rectangle& iOther) const;

		// Set the top left point, recalculating the bottom right from the width and height.
		void SetTopLeft(const Point& iTopLeft);

	private:
		Point mTopLeft;
		Point mBottomRight;
	};
}

#endif
